--------------------------------------------------------------------------------------------------
------------ B17G mod by Markindel and Stonehouse

--------------------------------------------------------------------------------------------------

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/B17G.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_sound_path (current_mod_path.."/Sounds")

AN_M64_6 = 
{
	CLSID        = "AN_M64_6",
	category     = CAT_BOMBS,
	Picture	=	"M64.png",
	attribute	=	{4,	5,	9,	90},
	displayName	=	_("6 AN-M64"),
	Count	=	6,
	Weight	=	1361,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"AN-M64",
		}, 
	}, -- end of Elements
}
declare_loadout(AN_M64_6)

FAB_500_3 = 
{
	CLSID        = "FAB_500_3",
	category     = CAT_BOMBS,
	Picture	=	"FAB500.png",
	attribute	=	{4,	5,	9,	90},
	displayName	=	_("3 AN-M65"),
	Count	=	3,
	Weight	=	1361,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"FAB-500-N3",
		}, 
	}, -- end of Elements
}
declare_loadout(FAB_500_3)

B17G = 
{
	Name 				=   'B17G',
	DisplayName			= _('B17G'),
--	HumanCockpit 		= false,
	Picture 				= current_mod_path..'/Textures/B17G.png',
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "B17G",
	shape_table_data 	= 
	{
		{
			file  	 = 'B17G';
			life  	 = 150; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'B17G_destr'; -- Name of destroyed object file name
			fire  	 = { 500, 4}; -- Fire on the ground after destoyed: 500sec 4m
			username = 'B17G';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "B17G_destr";
			file  = "B17G-destr";
			fire  = { 500, 4};
		},

	},
	mapclasskey = "P0091000027",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Intruder, WSTYPE_PLACEHOLDER , "Strategic bombers"},
	Categories 			= {},

	-------------------------
	M_empty 					= 16400, -- kg
	M_nominal 					= 24950, -- kg
	M_max 						= 32659, -- kg
	M_fuel_max 					= 5000, -- kg
	length 						= 22.78, -- full lenght in m
	height 						= 5.82, -- height in m
	wing_area 					= 131.92, -- wing area in m2
	wing_span 					= 31.63, -- wing spain in m
	wing_type 					= 0,
	wing_tip_pos 				=  {0.908,	1.636, 21.415}, -- wingtip coords for visual effects
	
--	nose_gear_pos 				= {12.448,	-2.587,	0}, -- nosegear coord
--	main_gear_pos 				= {1.993,	-2.587,	4.503}, -- main gear coords
--	tand_gear_max 				= 0.577,
	
	nose_gear_pos				= 	{-10.522,	0.4,	0}, -- nosegear coord 3.769,	-2.353,	0  ----- Ruotino posteriore
	main_gear_pos 				= 	{0.635,	-0.5,	2.534}, -- main gear coords 0.072,	-2.374,	2.341	--- carrello principale
	tand_gear_max 				= 0.05,  -------- distance between main gears in m
	
	
	nose_gear_wheel_diameter 	= 0.793, -- in m
	main_gear_wheel_diameter 	= 1.395, -- in m
	stores_number				=	0,
	V_opt 						= 77,-- Cruise speed (for AI)
	V_take_off 					= 45, -- Take off speed in m/s (for AI) 288km/h
	V_land 						= 43, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 81, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 118, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 2.91, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.344, -- Max speed in Mach (for AI)
	H_max 					 	= 10850, -- m
	Ny_min 						= 0, -- Min G (for AI)
	Ny_max 						= 1.5,  -- Max G (for AI)
	Ny_max_e 					= 1.5,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 10, -- Max bank angle (for AI)
	average_fuel_consumption 	= 0.2527, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	range 						= 6600, -- Max range in km (for AI)
	crew_size	                = 9, 
	CAS_min 					= 72, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	thrust_sum_max 				= 50000,
	thrust_sum_ab 				= 50000,
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	RCS 						= 100, -- Radar Cross Section m2
	IR_emission_coeff 			= 1.5, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	engines_count				= 4, -- Engines count

------------------------------------------------------------------------------	
-- Fumo scarico motori {x,y,z}
------------------------------------------------------------------------------
	engines_nozzles = 
	{
		[1] = 
		{
				pos = 	{1.5,	1.1,	-3.5},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 1, --both to first engine
		},
		[2] = 
		{
			pos = 	{1.5,	1.1,	3.5},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 2, --both to first engine
		},
		[3] = 
		{
			pos = 	{1.5,	1.1,	-7},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 3, --both to first engine
		},
		[4] = 
		{
			pos = 	{1.5,	1.1,	7},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 4, --both to first engine
		},
	}, -- end of engines_nozzles
--------------------------------------------------------------------------------
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
--[[
	crew_size	 = 9,
	crew_members = 
	{
	}, -- end of crew_members
--]]

---------------------------------------------------------------------------------
--  equipaggio
---------------------------------------------------------------------------------

	crew_size	 = 9,
	crew_members = 
	{
			[1] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{8,	2,	0},
			}, -- end of [1]
			[2] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{5,	3,	-0.5},
			}, -- end of [2]
			[3] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{5,	3,	0.5},
			}, -- end of [3]
			[4] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-2.2,	1.0, 0},
			}, -- end of [4]
			[5] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-5,	2,	-0.3},
			}, -- end of [5]
			[6] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-5,	2,	0.3},
			}, -- end of [6]
			[7] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{4,	3.5,	0},
			}, -- end of [7]
			[8] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-12.5,	2,	0},
			}, -- end of [8]	
			[9] = 
			{	pilot_name          = "pilot_p51",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{3.5,	2,	0},
			}, -- end of [9]
	}, -- end of crew_members




	
	fires_pos = 
	{
		[1] = 	{-1.7, 1.1, 0.8},
		[2] = 	{-1.8, 1.3, 0.9},
		[3] = 	{5.5, 2, 2.2},
		[4] = 	{3.2, 0.265, 2.3},
		[5] = 	{-2.2, 0.5, 0},
		[6] = 	{1,	2.2, -8.5},
		[7] = 	{7.3, 0.95, 0},
	}, -- end of fires_pos
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,
	chaff_flare_dispenser 	= 
	{
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = 
	{
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = 
	{
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Guns = 
	{
		gun_mount("M_2", --chin
			{count = 5000},
			{muzzle_pos = {8.8, 1.3, 0.3},
			 supply_position = {8.0, 1.3, 0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,	
			}
		),
		gun_mount("M_2", --chin
			{count = 5000},
			{muzzle_pos = {8.8, 1.3, -0.3},
			 supply_position = {8.0, 1.3, -0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,	
			}
		),
		gun_mount("M_2", 
			{count = 5000}, --upper
			{muzzle_pos = {3.9, 3.8, 0.3},
			 supply_position = {3.9, 3.5, 0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			drop_cartridge = 0,			 
			}
		),
		gun_mount("M_2", --upper
			{count = 5000},
			{muzzle_pos = {3.9, 3.8, -0.3},
			 supply_position = {3.9, 3.5, -0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_2", --ball
			{count = 5000},
			{muzzle_pos = {-3.3, 0.7, 0.3},
			 supply_position = {-3.3, 0.7, 0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_2", --ball
			{count = 5000},
			{muzzle_pos = {-3.3, 0.7, -0.3},
			 supply_position = {-3.3, 0.7, -0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),		
		gun_mount("M_2",
			{count = 5000}, --waist
			{muzzle_pos = {-5, 2.2, 1.0},
			 supply_position = {-5, 2, 0.8},
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_2",
			{count = 5000}, --waist
			{muzzle_pos = {-5, 2.2, -1.0},
			 supply_position = {-5, 2, -0.8},
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),		
		gun_mount("M_2",
			{count = 5000}, --tail
			{muzzle_pos = {-14.0, 2.1, 0.3},
			 supply_position = {-12.5, 1.8, 0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_2",
			{count = 5000}, --tail
			{muzzle_pos = {-14.0, 2.1, -0.3},
			 supply_position = {-12.5, 1.8, -0.3},
			 barrel_circular_error = 0.007,
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),		
	},
	
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra	
	
	Pylons = 
    {
		-- Parameter 2 = Internal or External pylon, so if its set to 2 it fires the Argument #26
 --       pylon(1, 2, 7.7, -0.5, 0, FAB_500_3
  --      pylon(1, 2, 7.7, 1.5, 0,
		pylon(1, 2, 0.0, 1.4, -0.4,
            {
            },
            {
				{ CLSID = "AN_M64_6" },
				{ CLSID = "FAB_500_3" },
            }
        ),
--        pylon(2, 2, 1.8, -0.5, 0,
		pylon(2, 2, 0.0, 1.4, 0.4,
            {
            },
            {
				{ CLSID = "AN_M64_6" },
				{ CLSID = "FAB_500_3" },
            }
        ),
    },

	Tasks = 
	{
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(RunwayAttack),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.2,  -- zero AoA lift coefficient
			Mzalfa		=	6.6,  -- coefficients for pitch agility
			Mzalfadt	=	1,    -- coefficients for pitch agility
			kjx			=	2.0,    
			kjz			=	0.00125, 
			Czbe		=	-0.012, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.015,    -- coefficient, drag, gear
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	1.2,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{
			--   M		Cx0		Cya		B		B4			Omxmax	Aldop	Cymax
				{0,		0.024,	0.1,	0.0426,	1e-006,	0.5,	20,	1.2},
				{0.1,	0.024,	0.1,	0.0426,	1e-006,	1,		20,	1.2},
				{0.2,	0.024,	0.1,	0.0426,	1e-006,	1.5,	20,	1.2},
				{0.3,	0.024,	0.1,	0.0426,	1e-006,	2,		20,	1.2},
				{0.4,	0.024,	0.1,	0.0426,	1e-006,	2.5,	20,	1.2},
				{0.5,	0.024,	0.1,	0.0426,	1e-006,	3,		20,	1.2},
				{0.6,	0.024,	0.1,	0.044,	1e-006,	3.5,	20,	1.2},
				{0.7,	0.025,	0.1,	0.045,	0.02,	3.5,	20,	1},
				{0.8,	0.029,	0.1,	0.049,	0.05,	3.5,	20,	0.9},
				{0.9,	0.04,	0.1,	0.071,	0.07,	3.5,	20,	0.8},
				{1,		0.06,	0.1,	0.138,	0.2,	3.5,	20,	0.76666666666667},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	700, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			typeng	=	2,
			--	E_TURBOJET = 0
			--	E_TURBOJET_AB = 1
			--	E_PISTON = 2
			--	E_TURBOPROP = 3
			--	E_TURBOFAN	= 4
			--	E_TURBOSHAFT = 5
			hMaxEng	=	19.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	19000, --  altitude coefficient for max thrust
			dpdh_f	=	19000, --  altitude coefficient for AB thrust
			table_data = 
			{
			--   M		Pmax		 Pfor	
				{0,		608000,	608000},
				{0.1,	568000,	568000},
				{0.2,	520000,	520000},
				{0.3,	484000,	484000},
				{0.4,	440000,	440000},
				{0.5,	418000,	418000},
				{0.6,	410000,	410000},
				{0.7,	436000,	436000},
				{0.798,	470000,	470000},
				{0.9,	524000,	524000},
				{1,		560000,	560000},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,
			MAX_Manifold_P_2	= 206570,
			MAX_Manifold_P_3	= 226648,
			k_after_cool		= 0.54,
			Displ				= 27,
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 12,
			Nu_0				= 15.0,
			Nu_1				= 2.4,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 3.45,
			MOI_prop			= 65,
			k_gearbox			= 2.088,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
		}, -- end of engine
	}, -- end of SFM_Data

--[[
To break the entries down:

eg oh58d_cells_properties[0] = {critical_damage = 4, args = {161},deps_cells = {11,12},droppable=false}
   ----------green------- loc   ----------red------  ---blue----  ------yellow--------
Green is the model name and part# as referenced in the list at top of the damage.lua

Red, amount of damage it can sustain before something falls off or 
you get shot down. Some parts will have an extra section named deps_cells, 
I think these parts fall off when the particular part reaches its critical
damage amount unless droppable = false. 
Blue is 3D model argument # of the damage part
Yellow is the damage cells affected by damage on this location
	--]]
----------------------------------------------------------------------------------------------------
---  Damage Section
-----------------------------------------------------------------------------------------------------	

Damage = {

	[0]  = {critical_damage = 10}, 
	[1]	 = {critical_damage = 20, args = {154}, deps_cells = {4, 9}, droppable = false}, -- nose left
 	[4]	= {critical_damage = 25, args = {154}, deps_cells = {1, 9}, droppable = false},-- cabin left
	[9]  = {critical_damage =25, args = {154}, deps_cells = {1, 4}, droppable = false},  --fuselage left
	[2]	 = {critical_damage = 20, args = {153},  deps_cells = {5, 10}, droppable = false}, -- nose right	
	[5]	= {critical_damage = 25, args = {153},  deps_cells = {2, 10}, droppable = false},-- cabin right		
	[6]	= {critical_damage = 25},-- cabin bottom		
	[10]  = {critical_damage = 25, args = {153},  deps_cells = {2, 5}, droppable = false},  --fuselage right	
	[3]  = {critical_damage = 15},  --cockpit
	[8]  = {critical_damage = 6}, --gear
	[15]  = {critical_damage = 6}, --gear
	[16]  = {critical_damage = 6}, --gear
	[11] = {critical_damage = 8, args = {168}, deps_cells={13, 17}},  -- Engine in left 167,168 both affect left engines
	[13] = {critical_damage = 8, args = {168}, deps_cells={11, 17}},  -- Engine in left nacelle	
	[17] = {critical_damage = 8, args = {168}, deps_cells={11, 13}}, --engine out left
	[12] = {critical_damage = 8, args = {214},  deps_cells = {14, 18, 24, 26, 30, 32, 36, 38},droppable=false},  -- Engine in right	
	[14] = {critical_damage = 8, args = {214},  deps_cells = {12, 18, 24, 26, 30, 32, 36, 38},droppable=false},  -- Engine in right nacelle
	[18] = {critical_damage = 8, args = {214},  deps_cells = {12, 14, 24, 26, 30, 32, 36, 38},droppable=false}, -- engine out right
	[24] = {critical_damage = 25, args = {214}, deps_cells = {12, 14, 18, 26, 30, 32, 36, 38},droppable=false},-- wing out right 
	[26] = {critical_damage = 2, args = {214},  deps_cells = {12, 14, 18, 24, 30, 32, 36, 38},droppable=false}, --aileron right
 	[30] = {critical_damage = 25, args = {214}, deps_cells = {12, 14, 18, 24, 26, 32, 36, 38},droppable=false},-- wing center right does whole right wing and engines	
	[36] = {critical_damage = 30, args = {214}, deps_cells = {12, 14, 18, 24, 26, 30, 32, 38},droppable=false},   --wing in right
	[38] = {critical_damage = 2,args = {214},   deps_cells = {12, 14, 18, 24, 26, 30, 32, 36},droppable=false},-- flap in right
	[23] = {critical_damage = 25, args = {223}, deps_cells = {25}, droppable = false}, -- wing out left 223 does outer left	
	[25] = {critical_damage = 2, args = {223}, deps_cells = {23},droppable = false},  --aileron left
	[29] = {critical_damage = 25, args = {225}, deps_cells = {35, 37},droppable=false}, -- wing center left 
	[35] = {critical_damage = 30, args = {225}, deps_cells = {29, 37},droppable=false}, -- wing in left  225 does wing in left
	[37] = {critical_damage = 2, args = {225}, deps_cells = {29, 35},droppable=false}, -- flap in left 
	[39] = {critical_damage = 5}, -- fin top left
	[40] = {critical_damage = 5}, -- fin top right
	[41] = {critical_damage = 5}, -- fin centre left
	[42] = {critical_damage = 5}, -- fin centre right
	[43] = {critical_damage = 5}, -- fin bottom left	
	[44] = {critical_damage = 5},  --fin bottom right
	[45] = {critical_damage = 5, args = {235}, deps_cells={50}}, -- stabilizer out left 235 does stab and elevator
	[46] = {critical_damage = 5, args = {233}, deps_cells={29}}, -- stabilizer out right 233 does stab and elevator	
	[47] = {critical_damage = 5},-- stabilizer in left
	[48] = {critical_damage = 5}, -- stabilizer in right
	[49] = {critical_damage = 2},-- elevator out left
	[50] = {critical_damage = 2},-- elevator out right
	[51] = {critical_damage = 2}, --elevator in left
	[52] = {critical_damage = 2}, --elevator in right
	[53] = {critical_damage = 5, args = {243, 247}, deps_cells={39, 40, 41, 42, 43, 44, 54}}, --rudder left
	[54] = {critical_damage = 5, args = {243, 247}, deps_cells={39, 40, 41, 42, 43, 44, 53}}, -- rudder right, 247 does whole rudder both sides
	[55] = {critical_damage = 25}, -- tail 
	[56] = {critical_damage = 25},-- tail left
	[57] = {critical_damage = 25},-- tail right
	[59] = {critical_damage = 20}, -- nose bottom 
	[61] = {critical_damage = 6}, -- fuel tank left
	[62] = {critical_damage = 6}, -- fuel tank right
	[82] = {critical_damage = 25},-- fuselage bottom
	[83] = {critical_damage = 2, droppable=false}, -- wheel nose 
	[84] = {critical_damage = 2, droppable=false}, -- wheel left 
	[85] = {critical_damage = 2, droppable=false}, -- wheel right 
	
	},	
DamageParts = 
	{  
		[1] = "B17G-oblomok-wing-r",
		[2] = "B17G-oblomok-wing-l",
		[3] = "B17G-Motore_1", 	
		[4] = "B17G-Motore-2", 
		
	},
	
----------------------------------------------------------------------------------------------------
---  End Damage Section
-----------------------------------------------------------------------------------------------------	
	lights_data = 
	{
		typename = "collection",
		lights = 
		{
			[1] = -- 
			{
			},
			[2] = -- 
			{
			},
		    [3]	= -- 
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					color = {0.32, 0.0, 0.07},
					position  = {3.74, 1.44, -21.45},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					color = {0, 0.26, 0.18},
					position = {3.74, 1.44, 21.45},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					color = {0.8, 0.8, 0.8},
					position  = {-13.2, 0.33, 0.0},
					argument  = 203
					},
				}
			},
		    [4] = -- 
			{
			},
			[5]	=
			{
			}
		}
	},  -- end of lights_data

}

add_aircraft(B17G)